cd "D:\硕士工作\气候金融\工作一 大宗商品与气候感知\投稿\金融研究\数据"

//选择数据
import delimited "金属市场.csv",clear

encode id ,gen(newid)

//请保证原始数据时间格式为yyyy/mm/dd,如2020/01/01
encode day ,gen(newtime)

xtset newid newtime	

//全球变暖关注度差分处理
gen DSVI=d.gsvi

//########全球变暖关注度-->大宗商品市场收益率########
//计算收益率
gen lnprice=log(price)*100
gen RET=d.lnprice
//缩尾处理
winsor2 RET,replace cut(1,99) by(newid)

//选取最优滞后阶数
pvarsoc  DSVI RET, maxlag(4)

//模型估计-默认采用海默特正交差分-默认使用滞后1期至最后滞后期的内生变量作为工具变量
pvar2 DSVI RET, lags(1)
estimate store estpvar

//绘制正交脉冲响应结果
pvarirf, oirf porder(DSVI RET) iter(200) dots step(8)

//########全球变暖关注度-->大宗商品市场波动率########
rename vol VOL
winsor2 VOL, replace cut(0,99) by(newid)

pvarsoc DSVI VOL,maxlag(4) 

pvar2 DSVI VOL, lags(1) 
estimates store estpvar

pvarirf, oirf porder(DSVI VOL) iter(200) dots step(8) 

//########全球变暖关注度-->大宗商品市场不确定性########
gen DUNC=d.unc*100

winsor2 DUNC, replace cut(0,99) by(newid)

pvarsoc DSVI DUNC,maxlag(4)

pvar2 DSVI DUNC,lag(1)
estimates store estpvar

pvarirf, oirf porder(DSVI DUNC) iter(200) dots step(8) 

